
from py_pli.pylib import VUnits

import PyRunner.config_enum.scan_table_enum as scan_table_enum

# fleming.hta.scantable_location.scanTable_init
async def scanTable_init(*args):
    if len(args)>0:
        platetype=args[0]
    else:
        platetype="'384 OptiPlate (White)'"
    st = VUnits.instance.hal.scan_table
    st.SetPlateType(platetype) # follow the function, there is a list of accepted names
    await st.Home()
    st.SetCurrentMeasPosition(scan_table_enum.GC_Params.FBDTop_TopLeftCorner)
    st.get_config(scan_table_enum.GC_Params.FBDTop_TopLeftCorner)
    scanTable_init.initialized = True
    return scan_table_enum

async def scantable_location(*args):
    await scantable_move_close_to_home()
    await scanTable_init()
    st = VUnits.instance.hal.scan_table
    if len(args)>1:
        await st.Move(args[0],args[1])
    return st.get_current_position()

# fleming.hta.scantable_location.scantable_96plate_location
async def scantable_96plate_location(*args):
    await scantable_move_close_to_home()
    await scanTable_init("'96 Test Plate'")
    st = VUnits.instance.hal.scan_table
    if len(args)>1:
        await st.MoveToWell(args[0],args[1])
    return st.get_current_position()

# fleming.hta.scantable_location.scantable_384plate_location
async def scantable_384plate_location(*args):
    await scantable_move_close_to_home()
    await scanTable_init("'384 OptiPlate (White)'")
    st = VUnits.instance.hal.scan_table
    if len(args)>1:
        await st.MoveToWell(args[0],args[1])
    return st.get_current_position()


# fleming.hta.scantable_location.scantable_move_close_to_home
async def scantable_move_close_to_home():
    # print("started")
    st = VUnits.instance.hal.scan_table
    # print("2")
    try:
        # check if it is aproximately at home        
        # print("3")
        x0,y0 = st.get_current_position()
        # print(f"approxi home: {x0}, {y0}")
        if (x0>1.1) or (y0>1.1):
        # if not move to the approximate
            # print("try to move to approxi home")
            await st.Move(1.,1.)
    except:
        print('st move backto home approximation does not work!')

def reload():
    pass